;***********************************************
;	vhuf_.asm -- works for dynamic & static
;	             Huffman methods
;***********************************************
			page	0, 128

NC		=		(200h - 2)
NP		=		14
NT		=		19
NPT		=		080h

THRESHOLD	equ	3
N1		equ	256 + 60 - THRESHOLD + 1
N2		equ	N1 * 2
NN1		equ	2000h / 64
NN2		equ	NN1 * 2

DATA	segment word	public	'DATA'
DATA	ends

BSS		segment word	public	'DATA'
heap		dw		NC + 1 dup (?)

public	heap

avail_mt	dw		1 dup (?)
nchar		dw		1 dup (?)
bitlen		dw		1 dup (?)
freq		dw		1 dup (?)
code		dw		1 dup (?)
n2			dw		1 dup (?)
heapsize	dw		1 dup (?)
sort		dw		1 dup (?)
depth		dw		1 dup (?)

public	avail_mt
public	nchar
public	bitlen
public	freq
public	code
public	n2
public	heapsize
public	sort
public	depth
public	text_

text_			db		(2000h * 2 + 100h) dup(?)

parent_		label	word
left_			dw		2 * NC - 1 dup (?)

child_		label	word
right_			dw		2 * NC - 1 dup (?)

c_table_		dw		4096 dup (?)
c_code_			dw		NC dup (?)
pt_table_		dw		256 dup (?)
pt_code_		dw		NPT dup (?)
c_len_			db		NC dup (?)
pt_len_			db		NPT dup (?)
dummy			db		8000h - (pt_len_ + NPT - text_) dup (?)

public	freq_
public	c_freq_, p_freq_, t_freq_
public	parent_
public	left_
public	child_
public	right_
public	c_table_
public	c_code_
public	pt_table_
public	pt_code_
public	c_len_
public	pt_len_

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
			org		c_table_
freq_		label	word
c_freq_		dw		2 * NC - 1 dup (?)
p_freq_		dw		2 * NP - 1 dup (?)
t_freq_		dw		2 * NT - 1 dup (?)

block_		label	word
			dw		N2 dup (?)
			dw		NN2 dup (?)

edge_		label	word
			dw		N2 dup(?)
			dw		256 dup (?)

stock_		label	word
			dw		N2 dup (?)
			dw		NN2 dup (?)

public	block_
public	edge_
public	stock_

			org		heap
len_cnt		dw		17 dup (?)
start		dw		17 dup (?)
weight		dw		17 dup (?)

public	len_cnt
public	start
public	weight

			org		freq
tablebits	dw		1 dup (?)
table		dw		1 dup (?)

public	tablebits
public	table

BSS		ends

DGROUP	group		DATA, BSS

		end
